/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

public class PixelColor {
    static final float d = 0.003921569f;
    public final boolean alphaComposite;
    public float red;
    public float green;
    public float blue;
    public float alpha;

    public PixelColor() {
        this(true);
    }

    public PixelColor(boolean alphaComposite) {
        this.alphaComposite = alphaComposite;
    }

    public void clear() {
        this.alpha = 0.0f;
        this.blue = 0.0f;
        this.green = 0.0f;
        this.red = 0.0f;
    }

    public void composite(int argb) {
        this.composite(argb, 1.0f);
    }

    public void composite(int argb, float light) {
        if (this.alphaComposite) {
            float a2 = (float)(argb >> 24 & 0xFF) * 0.003921569f;
            float r2 = (float)(argb >> 16 & 0xFF) * 0.003921569f * light;
            float g2 = (float)(argb >> 8 & 0xFF) * 0.003921569f * light;
            float b2 = (float)(argb >> 0 & 0xFF) * 0.003921569f * light;
            this.red += (r2 - this.red) * a2;
            this.green += (g2 - this.green) * a2;
            this.blue += (b2 - this.blue) * a2;
            this.alpha += (1.0f - this.alpha) * a2;
        } else {
            this.alpha = (float)(argb >> 24 & 0xFF) * 0.003921569f;
            this.red = (float)(argb >> 16 & 0xFF) * 0.003921569f * light;
            this.green = (float)(argb >> 8 & 0xFF) * 0.003921569f * light;
            this.blue = (float)(argb >> 0 & 0xFF) * 0.003921569f * light;
        }
    }

    public void composite(float alpha, int rgb, float light) {
        if (this.alphaComposite) {
            float a2 = alpha;
            float r2 = (float)(rgb >> 16 & 0xFF) * 0.003921569f * light;
            float g2 = (float)(rgb >> 8 & 0xFF) * 0.003921569f * light;
            float b2 = (float)(rgb >> 0 & 0xFF) * 0.003921569f * light;
            this.red += (r2 - this.red) * a2;
            this.green += (g2 - this.green) * a2;
            this.blue += (b2 - this.blue) * a2;
            this.alpha += (1.0f - this.alpha) * a2;
        } else {
            this.alpha = (float)(rgb >> 24 & 0xFF) * 0.003921569f;
            this.red = (float)(rgb >> 16 & 0xFF) * 0.003921569f * light;
            this.green = (float)(rgb >> 8 & 0xFF) * 0.003921569f * light;
            this.blue = (float)(rgb >> 0 & 0xFF) * 0.003921569f * light;
        }
    }

    public void composite(float alpha, int rgb, float lr, float lg, float lb2) {
        if (this.alphaComposite) {
            float a2 = alpha;
            float r2 = (float)(rgb >> 16 & 0xFF) * 0.003921569f * lr;
            float g2 = (float)(rgb >> 8 & 0xFF) * 0.003921569f * lg;
            float b2 = (float)(rgb >> 0 & 0xFF) * 0.003921569f * lb2;
            this.red += (r2 - this.red) * a2;
            this.green += (g2 - this.green) * a2;
            this.blue += (b2 - this.blue) * a2;
            this.alpha += (1.0f - this.alpha) * a2;
        } else {
            this.alpha = (float)(rgb >> 24 & 0xFF) * 0.003921569f;
            this.red = (float)(rgb >> 16 & 0xFF) * 0.003921569f * lr;
            this.green = (float)(rgb >> 8 & 0xFF) * 0.003921569f * lg;
            this.blue = (float)(rgb >> 0 & 0xFF) * 0.003921569f * lb2;
        }
    }

    public void composite(float a2, float r2, float g2, float b2) {
        if (this.alphaComposite) {
            this.red += (r2 - this.red) * a2;
            this.green += (g2 - this.green) * a2;
            this.blue += (b2 - this.blue) * a2;
            this.alpha += (1.0f - this.alpha) * a2;
        } else {
            this.alpha = a2;
            this.red = r2;
            this.green = g2;
            this.blue = b2;
        }
    }

    public void composite(float a2, float r2, float g2, float b2, float light) {
        if (this.alphaComposite) {
            this.red += (r2 * light - this.red) * a2;
            this.green += (g2 * light - this.green) * a2;
            this.blue += (b2 * light - this.blue) * a2;
            this.alpha += (1.0f - this.alpha) * a2;
        } else {
            this.alpha = a2;
            this.red = r2 * light;
            this.green = g2 * light;
            this.blue = b2 * light;
        }
    }
}

