/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import net.minecraft.client.Minecraft;
import reifnsk.minimap.GuiWaypointEditorScreen;
import reifnsk.minimap.GuiWaypointScreen;
import reifnsk.minimap.Waypoint;

class GuiWaypoint
extends awg {
    private static final int[] COLOR1 = new int[]{-1, -65536};
    private static final int[] COLOR2 = new int[]{-4144960, -4194304};
    private static final int COLOR_SIZE = 9;
    private static final int BUTTON_SIZE = 30;
    private static final int ADD_SPACE = 2;
    static final int SIZE = 45;
    private GuiWaypointScreen gws;
    private Waypoint waypoint;
    private int number;
    private String name;
    private int top;
    private int bottom;
    private int left;
    private int right;
    private int ctop;
    private int cbottom;
    private int cleft;
    private int cright;
    private int btop;
    private int bbottom;
    private int bleft;
    private int bright;
    private long clickTime = System.nanoTime();

    GuiWaypoint(int i2, GuiWaypointScreen gws) {
        super(i2, 0, 0, 0, 0, null);
        this.gws = gws;
    }

    void setWaypoint(int num, Waypoint pt2) {
        this.number = num;
        this.waypoint = pt2;
        this.name = null;
    }

    @Override
    public void a(Minecraft minecraft, int i2, int j2) {
        String text;
        boolean hover;
        if (this.waypoint == null) {
            return;
        }
        awv fontRenderer = minecraft.q;
        if (this.name == null) {
            this.name = this.number + ") " + this.waypoint.name;
            while (fontRenderer.a(this.name) > 160) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
        }
        this.b(fontRenderer, this.name, this.c + 1, this.d + 1, ((hover = this.mouseIn(i2, j2)) ? COLOR1 : COLOR2)[this.waypoint.type]);
        boolean tooltip = hover && i2 < this.cleft;
        int r2 = (int)(this.waypoint.red * 255.0f) & 0xFF;
        int g2 = (int)(this.waypoint.green * 255.0f) & 0xFF;
        int b2 = (int)(this.waypoint.blue * 255.0f) & 0xFF;
        int color = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
        GuiWaypoint.a(this.cleft, this.ctop, this.cright, this.cbottom, color);
        hover = this.buttonIn(i2, j2);
        String string = this.gws.getRemoveMode() ? (this.gws.isRemove(this.waypoint) ? "X" : "KEEP") : (text = this.waypoint.enable ? "ON" : "OFF");
        color = hover ? -2130706433 : (text == "X" ? -1593901056 : (text == "KEEP" ? -1610547456 : (this.waypoint.enable ? -1610547456 : -1593901056)));
        GuiWaypoint.a(this.bleft, this.btop, this.bright, this.bbottom, color);
        this.a(minecraft.q, text, this.bleft + this.bright >> 1, this.btop + 1, -1);
        if (tooltip) {
            String tooltipText = String.format("X:%d, Y:%d, Z:%d", this.waypoint.x, this.waypoint.y, this.waypoint.z);
            int width = fontRenderer.a(tooltipText);
            int drawLeft = i2 - width / 2 - 1;
            int drawRight = drawLeft + width + 2;
            GuiWaypoint.a(drawLeft, j2 - 11, drawRight, j2 - 1, -1610612736);
            this.a(fontRenderer, tooltipText, i2, j2 - 10, -1);
        }
    }

    @Override
    public boolean c(Minecraft minecraft, int i2, int j2) {
        if (this.waypoint == null) {
            return false;
        }
        if (this.mouseIn(i2, j2)) {
            if (this.colorIn(i2, j2)) {
                this.waypoint.red = (float)Math.random();
                this.waypoint.green = (float)Math.random();
                this.waypoint.blue = (float)Math.random();
                this.gws.updateWaypoint(this.waypoint);
                return true;
            }
            if (this.buttonIn(i2, j2)) {
                if (this.gws.getRemoveMode()) {
                    this.gws.removeWaypoint(this.waypoint);
                } else {
                    this.waypoint.enable = !this.waypoint.enable;
                    this.gws.updateWaypoint(this.waypoint);
                }
                return true;
            }
            long time = System.nanoTime();
            if (!this.gws.getRemoveMode() && time < this.clickTime + 300000000L) {
                minecraft.a(new GuiWaypointEditorScreen(this.gws, this.waypoint));
                return true;
            }
            this.clickTime = time;
        }
        return false;
    }

    void bounds(int x2, int y2, int w2, int h2) {
        this.c = x2;
        this.d = y2;
        this.a = w2;
        this.b = h2;
        this.top = y2;
        this.bottom = y2 + h2;
        this.left = x2;
        this.right = x2 + w2;
        this.ctop = this.top;
        this.cbottom = this.bottom;
        this.cright = this.right - 2 - 30 - 2;
        this.cleft = this.cright - 9;
        this.btop = this.top;
        this.bbottom = this.bottom;
        this.bright = this.right - 2;
        this.bleft = this.bright - 30;
    }

    private boolean mouseIn(int x2, int y2) {
        return y2 >= this.top && y2 < this.bottom && x2 >= this.left && x2 < this.right;
    }

    private boolean colorIn(int x2, int y2) {
        return y2 >= this.ctop && y2 < this.cbottom && x2 >= this.cleft && x2 < this.cright;
    }

    private boolean buttonIn(int x2, int y2) {
        return y2 >= this.btop && y2 < this.bbottom && x2 >= this.bleft && x2 < this.bright;
    }
}

